IF EXISTS (SELECT 1 FROM sys.views  WHERE object_id = OBJECT_ID(N'[dbo].[V_QUITACOES_RELATORIO]'))
    DROP VIEW [dbo].[V_QUITACOES_RELATORIO];
GO
CREATE VIEW [dbo].[V_QUITACOES_RELATORIO]
AS
     /*QUITACAO DE FATURAS CREDIARIO*/
	SELECT DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CX, 
		DBO.RC_PGTO_PDV.CD_CTR_PGTO, 
		DBO.PDV_CUPOM_NAO_FISCAL.NR_COO, 
		DBO.PDV_CUPOM_NAO_FISCAL.DT_CUPOM,
		CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
			THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
			ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END AS VLR_TOT_CUPOM, 
		CAST(((CAST((CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
			THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
			ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_DINH AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_DINH, 
		CAST(((CAST((CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
			THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
			ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_CHQS AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_CHQS, 
		CAST(((CAST((CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
			THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
			ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_CARTAO AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_CARTAO, 
		CAST(RC_PGTO_PDV.DT_PGTO AS DATE) AS DT_PGTO, 
		DBO.RC_PGTO_PDV.STS_PGTO, 
		ISNULL(DBO.RC_DEB.NR_FATURA, '0') AS NR_FATURA, 
		1 AS PARC, 
		ISNULL(DBO.RC_DEB.DT_VENCTO, CONVERT(DATETIME, '1900-01-01 00:00:00', 102)) AS DT_VENCTO_FAT, 
		ISNULL(DBO.RC_DEB.VLR_DP, 0) AS VLR_ORIG_FATURA, 
		-- (ISNULL(DBO.RC_CRED.VL_PGTO, 0) - ISNULL(DBO.RC_CRED.VL_DESC, 0)) AS VLR_AMORTIZADO, 
		ISNULL(RC_CRED.VL_PGTO, 0)  AS VLR_AMORTIZADO,
		ISNULL(DBO.RC_CRED.VL_JUR, 0) AS VLR_JUR, 
		ISNULL(DBO.RC_CRED.VL_DESC, 0) AS VLR_DESC,
		CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
			THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
			ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END AS VLR_PAGO, 
		ISNULL(DBO.RC_DEB.SLD_DP, 0) AS VLR_SALDO, 
		ISNULL(DBO.RC_CLI.CD_CLI, 0) AS CD_CLI, 
		ISNULL(DBO.RC_CLI.RZ_CLI, '') AS RZ_CLI, 
		ISNULL(DBO.RC_CLI.END_CLI, '') AS END_CLI, 
		ISNULL(DBO.RC_CLI.BAIRRO, '') AS BAIRRO, 
		ISNULL(DBO.RC_CLI.NUMERO, '') AS NUMERO, 
		ISNULL(DBO.GLB_CID.DS_CID, '') AS DS_CID, 
		ISNULL(DBO.RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI, 0) AS CD_MOT_BLOQ, 
		ISNULL(DBO.RC_MOT_BLOQ_CLI.DS_MOT_BLOQ_CLI, 'LIBERADO') AS DS_MOT_BLOQ, 
		'QUITACAO DE FATURA' AS TP_PAGAMENTO,
		CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
			THEN 'ESTORNADO'
			ELSE 'QUITADO'
		END AS SITUACAO, 
		PDV_CUPOM_NAO_FISCAL.HR_CUPOM, 
		RC_CLI.CGC_CPF, 
		PDV_CUPOM_NAO_FISCAL.CD_USU AS CD_OPER, 
		RC_CRED.CD_CNT, 
		BC_CONTAS.DS_CNT, 
		PDV_CUPOM_NAO_FISCAL.CD_USU, 
		GLB_REG.DS_REG, 
		RC_MDL_VENDA.DS_MDL_VD, 
		RC_MDL_VENDA.CD_MDL_VD, 
		0 AS CONSULTA, 
		0 AS FIL_VENDA, 
		0  AS CAIXA_VENDA, 
		0 AS CUPOM_VENDA,
		ISNULL(RC_DEB.DT_CAD,'') AS DT_VD

	FROM DBO.RC_PGTO_PDV_RC_CRED
		INNER JOIN DBO.RC_CRED ON DBO.RC_PGTO_PDV_RC_CRED.CD_EMP = DBO.RC_CRED.CD_EMP
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_FILIAL = DBO.RC_CRED.CD_FILIAL
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = DBO.RC_CRED.CD_RC_DEB
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_DP_LANC = DBO.RC_CRED.CD_DP_LANC
		INNER JOIN DBO.RC_DEB ON DBO.RC_PGTO_PDV_RC_CRED.CD_EMP = DBO.RC_DEB.CD_EMP
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_FILIAL = DBO.RC_DEB.CD_FILIAL
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = DBO.RC_DEB.CD_RC_DEB
		LEFT JOIN DBO.RC_CREDIARIO_FECHA_RC_DEB ON DBO.RC_DEB.CD_EMP = DBO.RC_CREDIARIO_FECHA_RC_DEB.CD_EMP
		AND DBO.RC_DEB.CD_FILIAL = DBO.RC_CREDIARIO_FECHA_RC_DEB.CD_FILIAL
		AND DBO.RC_DEB.CD_RC_DEB = DBO.RC_CREDIARIO_FECHA_RC_DEB.CD_RC_DEB
		INNER JOIN DBO.RC_CLI ON DBO.RC_DEB.CD_EMP = DBO.RC_CLI.CD_EMP
		AND DBO.RC_DEB.CD_CLI = DBO.RC_CLI.CD_CLI
		INNER JOIN DBO.GLB_CID ON DBO.RC_CLI.CD_CID = DBO.GLB_CID.CD_CID
		LEFT OUTER JOIN DBO.RC_CLI_CREDIARIO ON DBO.RC_CLI.CD_EMP = DBO.RC_CLI_CREDIARIO.CD_EMP
		AND DBO.RC_CLI.CD_CLI = DBO.RC_CLI_CREDIARIO.CD_CLI
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		INNER JOIN DBO.RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = DBO.RC_PGTO_PDV.CD_CTR_PGTO ON DBO.RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO = DBO.RC_PGTO_PDV.CD_CTR_PGTO
		LEFT OUTER JOIN DBO.RC_MOT_BLOQ_CLI ON DBO.RC_CLI_CREDIARIO.CD_MOT_BLOQ_CLI = DBO.RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI
		INNER JOIN BC_CONTAS ON RC_CRED.CD_EMP = BC_CONTAS.CD_EMP
		AND RC_CRED.CD_CNT = BC_CONTAS.CD_CNT
		LEFT JOIN GLB_REG ON GLB_REG.CD_EMP = RC_CLI.CD_EMP
		AND GLB_REG.CD_REG = RC_CLI.CD_REGI
		LEFT JOIN RC_MDL_VENDA ON RC_CLI_CREDIARIO.CD_EMP = RC_MDL_VENDA.CD_EMP
		AND RC_CLI_CREDIARIO.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD

	WHERE RC_CLI.CD_EMP = 1
		AND NOT EXISTS
		(
		SELECT RC_VD_CONV_RC_DEB.CD_FILIAL
		FROM RC_VD_CONV_RC_DEB
		WHERE RC_VD_CONV_RC_DEB.CD_EMP = RC_CRED.CD_EMP
			AND RC_VD_CONV_RC_DEB.CD_FILIAL = RC_CRED.CD_FILIAL
			AND RC_VD_CONV_RC_DEB.CD_RC_DEB = RC_CRED.CD_RC_DEB
		)
	 
     UNION ALL

     /*QUITACAO DE FATURAS CONVENIO*/

     SELECT DISTINCT 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CX, 
		DBO.RC_PGTO_PDV.CD_CTR_PGTO, 
		DBO.PDV_CUPOM_NAO_FISCAL.NR_COO, 
		DBO.PDV_CUPOM_NAO_FISCAL.DT_CUPOM,
		CASE WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3 THEN 
			DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
		ELSE
			(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END AS VLR_TOT_CUPOM, 
		CAST(((CAST((CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
				THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
			ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_DINH AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_DINH, 
		CAST(((CAST((CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
				THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
			ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_CHQS AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_CHQS, 
		CAST(((CAST((CASE
			WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
				THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
			ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_CARTAO AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_CARTAO, 
		CAST(RC_PGTO_PDV.DT_PGTO AS DATE) AS DT_PGTO, 
		DBO.RC_PGTO_PDV.STS_PGTO, 
		ISNULL(DBO.RC_DEB.NR_FATURA, '0') AS NR_FATURA, 
		1 AS PARC, 
		ISNULL(DBO.RC_DEB.DT_VENCTO, CONVERT(DATETIME, '1900-01-01 00:00:00', 102)) AS DT_VENCTO_FAT, 
		ISNULL(DBO.RC_DEB.VLR_DP, 0) AS VLR_ORIG_FATURA, 
		--(ISNULL(DBO.RC_CRED.VL_PGTO, 0) - ISNULL(DBO.RC_CRED.VL_DESC, 0)) AS VLR_AMORTIZADO, 
		ISNULL(RC_CRED.VL_PGTO, 0)  AS VLR_AMORTIZADO,
		ISNULL(DBO.RC_CRED.VL_JUR, 0) AS VLR_JUR, 
		ISNULL(DBO.RC_CRED.VL_DESC, 0) AS VLR_DESC,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
		ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END AS VLR_PAGO, 
		ISNULL(DBO.RC_DEB.SLD_DP, 0) AS VLR_SALDO, 
		ISNULL(DBO.RC_CLI.CD_CLI, 0) AS CD_CLI, 
		ISNULL(DBO.RC_CLI.RZ_CLI, '') AS RZ_CLI, 
		ISNULL(DBO.RC_CLI.END_CLI, '') AS END_CLI, 
		ISNULL(DBO.RC_CLI.BAIRRO, '') AS BAIRRO, 
		ISNULL(DBO.RC_CLI.NUMERO, '') AS NUMERO, 
		ISNULL(DBO.GLB_CID.DS_CID, '') AS DS_CID, 
		ISNULL(DBO.RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI, 0) AS CD_MOT_BLOQ, 
		ISNULL(DBO.RC_MOT_BLOQ_CLI.DS_MOT_BLOQ_CLI, 'LIBERADO') AS DS_MOT_BLOQ, 
		'QUITACAO DE FATURA' AS TP_PAGAMENTO,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN 'ESTORNADO'
		ELSE 'QUITADO'
		END AS SITUACAO, 
		PDV_CUPOM_NAO_FISCAL.HR_CUPOM, 
		RC_CLI.CGC_CPF, 
		PDV_CUPOM_NAO_FISCAL.CD_USU AS CD_OPER, 
		RC_CRED.CD_CNT, 
		BC_CONTAS.DS_CNT, 
		PDV_CUPOM_NAO_FISCAL.CD_USU, 
		GLB_REG.DS_REG, 
		RC_MDL_VENDA.DS_MDL_VD, 
		RC_MDL_VENDA.CD_MDL_VD, 
		1 AS CONSULTA, 
		0 AS FIL_VENDA, 
		0 AS CAIXA_VENDA, 
		0 AS CUPOM_VENDA,
		ISNULL(RC_DEB.DT_CAD,'') AS DT_VD
			
	FROM DBO.RC_PGTO_PDV_RC_CRED
		INNER JOIN DBO.RC_CRED ON DBO.RC_PGTO_PDV_RC_CRED.CD_EMP = DBO.RC_CRED.CD_EMP
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_FILIAL = DBO.RC_CRED.CD_FILIAL
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = DBO.RC_CRED.CD_RC_DEB
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_DP_LANC = DBO.RC_CRED.CD_DP_LANC
		INNER JOIN DBO.RC_DEB ON DBO.RC_PGTO_PDV_RC_CRED.CD_EMP = DBO.RC_DEB.CD_EMP
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_FILIAL = DBO.RC_DEB.CD_FILIAL
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = DBO.RC_DEB.CD_RC_DEB
		INNER JOIN DBO.RC_VD_CONV_RC_DEB ON DBO.RC_PGTO_PDV_RC_CRED.CD_EMP = DBO.RC_VD_CONV_RC_DEB.CD_EMP
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_FILIAL = DBO.RC_VD_CONV_RC_DEB.CD_FILIAL
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = DBO.RC_VD_CONV_RC_DEB.CD_RC_DEB
		INNER JOIN DBO.RC_CLI ON DBO.RC_DEB.CD_EMP = DBO.RC_CLI.CD_EMP
		AND DBO.RC_DEB.CD_CLI = DBO.RC_CLI.CD_CLI
		INNER JOIN DBO.GLB_CID ON DBO.RC_CLI.CD_CID = DBO.GLB_CID.CD_CID
		INNER JOIN DBO.RC_CLI_CONV_RC_CLI ON DBO.RC_CLI.CD_EMP = DBO.RC_CLI_CONV_RC_CLI.CD_EMP
		AND DBO.RC_CLI.CD_CLI = DBO.RC_CLI_CONV_RC_CLI.CD_CLI
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		INNER JOIN DBO.RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = DBO.RC_PGTO_PDV.CD_CTR_PGTO ON DBO.RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO = DBO.RC_PGTO_PDV.CD_CTR_PGTO
		INNER JOIN BC_CONTAS ON RC_CRED.CD_EMP = BC_CONTAS.CD_EMP
		AND RC_CRED.CD_CNT = BC_CONTAS.CD_CNT
		LEFT JOIN GLB_REG ON GLB_REG.CD_EMP = RC_CLI.CD_EMP
		AND GLB_REG.CD_REG = RC_CLI.CD_REGI
		LEFT JOIN RC_CLI_CONV ON RC_CLI_CONV.CD_EMP = RC_CLI.CD_EMP
		AND RC_CLI_CONV.CD_CLI = RC_CLI.CD_CLI
		AND RC_CLI_CONV.CD_CONV = RC_CLI_CONV_RC_CLI.CD_CONV
		LEFT OUTER JOIN DBO.RC_MOT_BLOQ_CLI ON DBO.RC_CLI_CONV.CD_MOT_BLOQUEIO = DBO.RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI
		LEFT JOIN RC_MDL_VENDA ON RC_CLI_CONV.CD_EMP = RC_MDL_VENDA.CD_EMP
		AND RC_CLI_CONV.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD

	WHERE RC_CLI.CD_EMP = 1

	UNION ALL

     /*QUITACAO DE FATURAS CONVENIO PROPRIO*/

     SELECT DISTINCT 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CX, 
		DBO.RC_PGTO_PDV.CD_CTR_PGTO, 
		DBO.PDV_CUPOM_NAO_FISCAL.NR_COO, 
		DBO.PDV_CUPOM_NAO_FISCAL.DT_CUPOM,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
		ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END AS VLR_TOT_CUPOM, 
		CAST(((CAST((CASE
					 WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
					 THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
					 ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
				 END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_DINH AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_DINH, 
		CAST(((CAST((CASE
					 WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
					 THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
					 ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
				 END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_CHQS AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_CHQS, 
		CAST(((CAST((CASE
					 WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
					 THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
					 ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
				 END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_CARTAO AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_CARTAO, 
		CAST(RC_PGTO_PDV.DT_PGTO AS DATE) AS DT_PGTO, 
		DBO.RC_PGTO_PDV.STS_PGTO, 
		ISNULL(DBO.RC_DEB.NR_FATURA, '0') AS NR_FATURA, 
		1 AS PARC, 
		ISNULL(DBO.RC_DEB.DT_VENCTO, CONVERT(DATETIME, '1900-01-01 00:00:00', 102)) AS DT_VENCTO_FAT, 
		ISNULL(DBO.RC_DEB.VLR_DP, 0) AS VLR_ORIG_FATURA, 
		--(ISNULL(DBO.RC_CRED.VL_PGTO, 0) - ISNULL(DBO.RC_CRED.VL_DESC, 0)) AS VLR_AMORTIZADO,
		ISNULL(RC_CRED.VL_PGTO, 0)  AS VLR_AMORTIZADO,
		ISNULL(DBO.RC_CRED.VL_JUR, 0) AS VLR_JUR, 
		ISNULL(DBO.RC_CRED.VL_DESC, 0) AS VLR_DESC,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
		ELSE(DBO.RC_CRED.VL_PGTO + ISNULL(DBO.RC_CRED.VL_JUR, 0)) - ISNULL(DBO.RC_CRED.VL_DESC, 0)
		END AS VLR_PAGO, 
		ISNULL(DBO.RC_DEB.SLD_DP, 0) AS VLR_SALDO, 
		ISNULL(DBO.RC_CLI.CD_CLI, 0) AS CD_CLI, 
		ISNULL(DBO.RC_CLI.RZ_CLI, '') AS RZ_CLI, 
		ISNULL(DBO.RC_CLI.END_CLI, '') AS END_CLI, 
		ISNULL(DBO.RC_CLI.BAIRRO, '') AS BAIRRO, 
		ISNULL(DBO.RC_CLI.NUMERO, '') AS NUMERO, 
		ISNULL(DBO.GLB_CID.DS_CID, '') AS DS_CID, 
		ISNULL(DBO.RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI, 0) AS CD_MOT_BLOQ, 
		ISNULL(DBO.RC_MOT_BLOQ_CLI.DS_MOT_BLOQ_CLI, 'LIBERADO') AS DS_MOT_BLOQ, 
		'QUITACAO DE FATURA' AS TP_PAGAMENTO,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN 'ESTORNADO'
		ELSE 'QUITADO'
		END AS SITUACAO, 
		PDV_CUPOM_NAO_FISCAL.HR_CUPOM, 
		RC_CLI.CGC_CPF, 
		PDV_CUPOM_NAO_FISCAL.CD_USU AS CD_OPER, 
		RC_CRED.CD_CNT, 
		BC_CONTAS.DS_CNT, 
		PDV_CUPOM_NAO_FISCAL.CD_USU, 
		GLB_REG.DS_REG, 
		RC_MDL_VENDA.DS_MDL_VD, 
		RC_MDL_VENDA.CD_MDL_VD, 
		2 AS CONSULTA, 
		0 AS FIL_VENDA, 
		0 AS CAIXA_VENDA, 
		0 AS CUPOM_VENDA,
		ISNULL(RC_DEB.DT_CAD,'') AS DT_VD
			
	FROM DBO.RC_PGTO_PDV_RC_CRED
		INNER JOIN DBO.RC_CRED ON DBO.RC_PGTO_PDV_RC_CRED.CD_EMP = DBO.RC_CRED.CD_EMP
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_FILIAL = DBO.RC_CRED.CD_FILIAL
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = DBO.RC_CRED.CD_RC_DEB
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_DP_LANC = DBO.RC_CRED.CD_DP_LANC
		INNER JOIN DBO.RC_DEB ON DBO.RC_PGTO_PDV_RC_CRED.CD_EMP = DBO.RC_DEB.CD_EMP
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_FILIAL = DBO.RC_DEB.CD_FILIAL
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = DBO.RC_DEB.CD_RC_DEB
		INNER JOIN DBO.RC_VD_CONV_RC_DEB ON DBO.RC_PGTO_PDV_RC_CRED.CD_EMP = DBO.RC_VD_CONV_RC_DEB.CD_EMP
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_FILIAL = DBO.RC_VD_CONV_RC_DEB.CD_FILIAL
		AND DBO.RC_PGTO_PDV_RC_CRED.CD_RC_DEB = DBO.RC_VD_CONV_RC_DEB.CD_RC_DEB


		INNER JOIN DBO.RC_CLI ON DBO.RC_DEB.CD_EMP = DBO.RC_CLI.CD_EMP
		AND DBO.RC_DEB.CD_CLI = DBO.RC_CLI.CD_CLI


		INNER JOIN DBO.GLB_CID ON DBO.RC_CLI.CD_CID = DBO.GLB_CID.CD_CID
		INNER JOIN DBO.RC_CLI_CONV_VINC_RC_CLI ON DBO.RC_CLI.CD_EMP = DBO.RC_CLI_CONV_VINC_RC_CLI.CD_EMP
		AND DBO.RC_CLI.CD_CLI = DBO.RC_CLI_CONV_VINC_RC_CLI.CD_CLI
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		INNER JOIN DBO.RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = DBO.RC_PGTO_PDV.CD_CTR_PGTO ON DBO.RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO = DBO.RC_PGTO_PDV.CD_CTR_PGTO
		INNER JOIN BC_CONTAS ON RC_CRED.CD_EMP = BC_CONTAS.CD_EMP
		AND RC_CRED.CD_CNT = BC_CONTAS.CD_CNT
		LEFT JOIN GLB_REG ON GLB_REG.CD_EMP = RC_CLI.CD_EMP
		AND GLB_REG.CD_REG = RC_CLI.CD_REGI

		INNER JOIN RC_VD_CONV ON 
		RC_VD_CONV_RC_DEB.CD_EMP=RC_VD_CONV.CD_EMP AND
		RC_VD_CONV_RC_DEB.CD_CTR=RC_VD_CONV.CD_CTR

		LEFT JOIN RC_CLI_CONV ON RC_CLI_CONV.CD_EMP = RC_VD_CONV.CD_EMP
		AND RC_CLI_CONV.CD_CONV = RC_VD_CONV.CD_CONV


		LEFT OUTER JOIN DBO.RC_MOT_BLOQ_CLI ON DBO.RC_CLI_CONV.CD_MOT_BLOQUEIO = DBO.RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI
		LEFT JOIN RC_MDL_VENDA ON RC_CLI_CONV.CD_EMP = RC_MDL_VENDA.CD_EMP
		AND RC_CLI_CONV.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD
		LEFT JOIN DBO.RC_CLI_CONV_RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CONV_RC_CLI.CD_EMP
		AND RC_CLI.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI
		
	WHERE RC_CLI.CD_EMP = 1
		AND RC_CLI_CONV_RC_CLI.CD_EMP IS NULL
	
	UNION ALL

     /* QUITA??ES DE FATURA NA RETAGUARDA */

	SELECT RC_CRED.CD_EMP, 
		RC_CRED.CD_FILIAL, 
		RC_CRED.CD_RC_DEB AS CD_CTR, --
		0 AS CD_CX, 
		RC_CRED.CD_RC_DEB AS CD_CTR_PGTO, 
		0 AS NR_COO, 
		RC_CRED.DT_PAG AS DT_CUPOM, 
		RC_CRED.VL_PGTO AS VLR_TOT_CUPOM, 
		RC_CRED.VL_PGTO AS VLR_DINH, 
		0 AS VLR_CHQS, -----
		0 AS VLR_CARTAO, ------
		CAST(RC_CRED.DT_PAG AS DATE) AS DT_PGTO, 
		0 AS STS_PGTO, ---
		ISNULL(DBO.RC_DEB.NR_FATURA, '0') AS NR_FATURA, 
		1 AS PARC, 
		ISNULL(RC_DEB.DT_VENCTO, CONVERT(DATETIME, '1900-01-01 00:00:00', 102)) AS DT_VENCTO_FAT, 
		ISNULL(RC_DEB.VLR_DP, 0) AS VLR_ORIG_FATURA, 
		--(ISNULL(RC_CRED.VL_PGTO, 0) - ISNULL(RC_CRED.VL_DESC, 0)) AS VLR_AMORTIZADO, 
		ISNULL(RC_CRED.VL_PGTO, 0)  AS VLR_AMORTIZADO,
		ISNULL(RC_CRED.VL_JUR, 0) AS VLR_JUR, 
		ISNULL(RC_CRED.VL_DESC, 0) AS VLR_DESC, 
		((RC_CRED.VL_PGTO + ISNULL(RC_CRED.VL_JUR, 0)) - ISNULL(RC_CRED.VL_DESC, 0)) AS VLR_PAGO, 
		ISNULL(RC_DEB.SLD_DP, 0) AS VLR_SALDO, 
		ISNULL(RC_CLI.CD_CLI, 0) AS CD_CLI, 
		ISNULL(RC_CLI.RZ_CLI, '') AS RZ_CLI, 
		ISNULL(RC_CLI.END_CLI, '') AS END_CLI, 
		ISNULL(RC_CLI.BAIRRO, '') AS BAIRRO, 
		ISNULL(RC_CLI.NUMERO, '') AS NUMERO, 
		ISNULL(GLB_CID.DS_CID, '') AS DS_CID, 
		ISNULL(RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI, 0) AS CD_MOT_BLOQ, 
		ISNULL(RC_MOT_BLOQ_CLI.DS_MOT_BLOQ_CLI, 'LIBERADO') AS DS_MOT_BLOQ, 
		'QUITACAO DE FATURA/BAIXA MANUAL' AS TP_PAGAMENTO, 
		'QUITADO' AS SITUACAO, 
		0 AS HR_CUPOM, 
		RC_CLI.CGC_CPF, 
		RC_CRED.CD_USU AS CD_OPER, --
		RC_CRED.CD_CNT, 
		BC_CONTAS.DS_CNT, 
		RC_CRED.CD_USU, 
		GLB_REG.DS_REG, 
		RC_MDL_VENDA.DS_MDL_VD, 
		RC_MDL_VENDA.CD_MDL_VD, 
		3 AS CONSULTA, 
		0 AS FIL_VENDA, 
		0 AS CAIXA_VENDA, 
		0 AS CUPOM_VENDA,
		ISNULL(RC_DEB.DT_CAD,'') AS DT_VD

	FROM RC_CRED
		INNER JOIN RC_DEB ON RC_CRED.CD_EMP = RC_DEB.CD_EMP
		AND RC_CRED.CD_FILIAL = RC_DEB.CD_FILIAL
		AND RC_CRED.CD_RC_DEB = RC_DEB.CD_RC_DEB
		INNER JOIN RC_CLI ON RC_DEB.CD_EMP = RC_CLI.CD_EMP
		AND RC_DEB.CD_CLI = RC_CLI.CD_CLI
		INNER JOIN GLB_CID ON RC_CLI.CD_CID = GLB_CID.CD_CID
		LEFT OUTER JOIN RC_CLI_CREDIARIO ON RC_CLI.CD_EMP = RC_CLI_CREDIARIO.CD_EMP
		AND RC_CLI.CD_CLI = RC_CLI_CREDIARIO.CD_CLI
		LEFT OUTER JOIN RC_MOT_BLOQ_CLI ON RC_CLI_CREDIARIO.CD_MOT_BLOQ_CLI = RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI
		INNER JOIN BC_CONTAS ON RC_CRED.CD_EMP = BC_CONTAS.CD_EMP
		AND RC_CRED.CD_CNT = BC_CONTAS.CD_CNT
		LEFT JOIN GLB_REG ON GLB_REG.CD_EMP = RC_CLI.CD_EMP
		AND GLB_REG.CD_REG = RC_CLI.CD_REGI
		LEFT JOIN RC_MDL_VENDA ON RC_CLI_CREDIARIO.CD_EMP = RC_MDL_VENDA.CD_EMP
		AND RC_CLI_CREDIARIO.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD
	WHERE RC_CLI.CD_EMP = 1
		AND NOT EXISTS
		(
		SELECT CD_CTR_PGTO
		FROM RC_PGTO_PDV_RC_CRED
		WHERE RC_PGTO_PDV_RC_CRED.CD_EMP = RC_CRED.CD_EMP
			AND RC_PGTO_PDV_RC_CRED.CD_FILIAL = RC_CRED.CD_FILIAL
			AND RC_PGTO_PDV_RC_CRED.CD_RC_DEB = RC_CRED.CD_RC_DEB
			AND RC_PGTO_PDV_RC_CRED.CD_DP_LANC = RC_CRED.CD_DP_LANC
		)
	
	UNION ALL

     /*ANTECIPACOES DE COMPRA*/

	SELECT DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CX, 
		DBO.RC_PGTO_PDV.CD_CTR_PGTO, 
		DBO.PDV_CUPOM_NAO_FISCAL.NR_COO, 
		DBO.PDV_CUPOM_NAO_FISCAL.DT_CUPOM,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
		ELSE DBO.RC_CREDIARIO_PARC_CRED.VLR_CRED
		END AS VLR_TOT_CUPOM, 
		CAST(((CAST((CASE
					 WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
					 THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
					 ELSE DBO.RC_CREDIARIO_PARC_CRED.VLR_CRED
				 END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_DINH AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_DINH, 
		CAST(((CAST((CASE
					 WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
					 THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
					 ELSE DBO.RC_CREDIARIO_PARC_CRED.VLR_CRED
				 END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_CHQS AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_CHQS, 
		CAST(((CAST((CASE
					 WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
					 THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
					 ELSE DBO.RC_CREDIARIO_PARC_CRED.VLR_CRED
				 END) AS NUMERIC(20, 10)) / CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS NUMERIC(20, 10))) * CAST(DBO.PDV_CUPOM_NAO_FISCAL.VLR_CARTAO AS NUMERIC(18, 2))) AS NUMERIC(18, 2)) AS VLR_CARTAO, 
		CAST(RC_PGTO_PDV.DT_PGTO AS DATE) AS DT_PGTO, 
		DBO.RC_PGTO_PDV.STS_PGTO, 
		CONVERT(VARCHAR(15), DBO.RC_CREDIARIO_PARC.CD_CTR) AS NR_FATURA, 
		DBO.RC_CREDIARIO_PARC.PARC_CRED AS PARC, 
		DBO.RC_CREDIARIO_PARC.DT_VENCTO_CRED AS DT_VENCTO_FAT, 
		DBO.RC_CREDIARIO_PARC.VLR_PARC_CRED AS VLR_ORIG_FATURA, 
		DBO.RC_CREDIARIO_PARC_CRED.VLR_CRED AS VLR_AMORTIZADO, 
		0 AS VLR_JUR, 
		0 AS VLR_DESC,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM
		ELSE DBO.RC_CREDIARIO_PARC_CRED.VLR_CRED
		END AS VLR_PAGO, 
		DBO.RC_CREDIARIO_PARC.SLD_PARC_CRED AS VLR_SALDO, 
		ISNULL(DBO.RC_CLI.CD_CLI, 0) AS CD_CLI, 
		ISNULL(DBO.RC_CLI.RZ_CLI, '') AS RZ_CLI, 
		ISNULL(DBO.RC_CLI.END_CLI, '') AS END_CLI, 
		ISNULL(DBO.RC_CLI.BAIRRO, '') AS BAIRRO, 
		ISNULL(DBO.RC_CLI.NUMERO, '') AS NUMERO, 
		ISNULL(DBO.GLB_CID.DS_CID, '') AS DS_CID, 
		ISNULL(DBO.RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI, 0) AS CD_MOT_BLOQ, 
		ISNULL(DBO.RC_MOT_BLOQ_CLI.DS_MOT_BLOQ_CLI, 'LIBERADO') AS DS_MOT_BLOQ, 
		'ANTECIPACAO DE COMPRA' AS TP_PAGAMENTO,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN 'ESTORNADO'
		ELSE 'QUITADO'
		END AS SITUACAO, 
		PDV_CUPOM_NAO_FISCAL.HR_CUPOM, 
		RC_CLI.CGC_CPF, 
		PDV_CUPOM_NAO_FISCAL.CD_USU AS CD_OPER, 
		BC_LANC.CD_CNT, 
		BC_CONTAS.DS_CNT, 
		PDV_CUPOM_NAO_FISCAL.CD_USU, 
		GLB_REG.DS_REG, 
		RC_MDL_VENDA.DS_MDL_VD, 
		RC_MDL_VENDA.CD_MDL_VD, 
		4 AS CONSULTA, 
		VD.CD_FILIAL AS FIL_VENDA, 
		VD.CD_CX AS CAIXA_VENDA, 
		VD.NR_ECF AS CUPOM_VENDA,
		VD.DT_VD
	FROM DBO.RC_CREDIARIO_PARC_CRED
		INNER JOIN DBO.RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED ON DBO.RC_CREDIARIO_PARC_CRED.CD_CTR = DBO.RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR
		AND DBO.RC_CREDIARIO_PARC_CRED.CD_CTR_CRED = DBO.RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_CRED
		INNER JOIN DBO.RC_CREDIARIO_PARC ON DBO.RC_CREDIARIO_PARC_CRED.CD_CTR = DBO.RC_CREDIARIO_PARC.CD_CTR
		INNER JOIN DBO.RC_CLI ON DBO.RC_CREDIARIO_PARC.CD_EMP = DBO.RC_CLI.CD_EMP
		AND DBO.RC_CREDIARIO_PARC.CD_CLI = DBO.RC_CLI.CD_CLI
		INNER JOIN DBO.GLB_CID ON DBO.RC_CLI.CD_CID = DBO.GLB_CID.CD_CID
		LEFT OUTER JOIN DBO.RC_CLI_CREDIARIO ON DBO.RC_CLI.CD_EMP = DBO.RC_CLI_CREDIARIO.CD_EMP
		AND DBO.RC_CLI.CD_CLI = DBO.RC_CLI_CREDIARIO.CD_CLI
		INNER JOIN DBO.RC_PGTO_PDV ON DBO.RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_PGTO = DBO.RC_PGTO_PDV.CD_CTR_PGTO
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR ON DBO.RC_PGTO_PDV.CD_CTR_PGTO = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO
		LEFT OUTER JOIN DBO.RC_MOT_BLOQ_CLI ON DBO.RC_CLI_CREDIARIO.CD_MOT_BLOQ_CLI = DBO.RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI
		LEFT OUTER JOIN RC_CREDIARIO_PARC_CRED_BC_LANC ON RC_CREDIARIO_PARC_CRED.CD_CTR = RC_CREDIARIO_PARC_CRED_BC_LANC.CD_CTR
		AND RC_CREDIARIO_PARC_CRED.CD_CTR_CRED = RC_CREDIARIO_PARC_CRED_BC_LANC.CD_CTR_CRED
		LEFT JOIN BC_LANC ON RC_CREDIARIO_PARC_CRED_BC_LANC.CD_EMP = BC_LANC.CD_EMP
		AND RC_CREDIARIO_PARC_CRED_BC_LANC.CD_BC_LANC = BC_LANC.CD_BC_LANC
		LEFT JOIN BC_CONTAS ON BC_LANC.CD_EMP = BC_CONTAS.CD_EMP
		AND BC_LANC.CD_CNT = BC_CONTAS.CD_CNT
		LEFT JOIN GLB_REG ON GLB_REG.CD_EMP = RC_CLI.CD_EMP
		AND GLB_REG.CD_REG = RC_CLI.CD_REGI
		LEFT JOIN RC_MDL_VENDA ON RC_CLI_CREDIARIO.CD_EMP = RC_MDL_VENDA.CD_EMP
		AND RC_CLI_CREDIARIO.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD
		LEFT OUTER JOIN RC_CREDIARIO_PARC_PDV_VD ON RC_CREDIARIO_PARC_PDV_VD.CD_EMP = RC_CREDIARIO_PARC.CD_EMP
		AND RC_CREDIARIO_PARC_PDV_VD.CD_CTR = RC_CREDIARIO_PARC.CD_CTR
		LEFT OUTER JOIN PDV_VD VD ON VD.CD_EMP = RC_CREDIARIO_PARC_PDV_VD.CD_EMP
		AND VD.CD_FILIAL = RC_CREDIARIO_PARC_PDV_VD.CD_FILIAL
		AND VD.CD_VD = RC_CREDIARIO_PARC_PDV_VD.CD_VD
	WHERE DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM <> 3
		AND RC_CLI.CD_EMP = 1
		
	UNION ALL

     /*ESTORNOS DE QUITACAO*/

	SELECT DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR, 
		DBO.PDV_CUPOM_NAO_FISCAL.CD_CX, 
		DBO.RC_PGTO_PDV.CD_CTR_PGTO, 
		DBO.PDV_CUPOM_NAO_FISCAL.NR_COO, 
		DBO.PDV_CUPOM_NAO_FISCAL.DT_CUPOM, 
		DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM, 
		DBO.PDV_CUPOM_NAO_FISCAL.VLR_DINH, 
		DBO.PDV_CUPOM_NAO_FISCAL.VLR_CHQS, 
		DBO.PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 
		CAST(DBO.RC_PGTO_PDV.DT_PGTO AS DATE) AS DT_PGTO, 
		DBO.RC_PGTO_PDV.STS_PGTO, 
		CONVERT(VARCHAR(15), 0) AS NR_FATURA, 
		0 AS PARC, 
		'1900-01-01 00:00:00' AS DT_VENCTO_FAT, 
		0 AS VLR_ORIG_FATURA, 
		0 AS VLR_AMORTIZADO, 
		0 AS VLR_JUR, 
		0 AS VLR_DESC, 
		ISNULL(DBO.PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM, 0) AS VLR_PAGO, 
		0 AS VLR_SALDO, 
		ISNULL(RC_CLI.CD_CLI, 0) AS CD_CLI, 
		ISNULL(RC_CLI.RZ_CLI, '') AS RZ_CLI, 
		'' AS END_CLI, 
		'' AS BAIRRO, 
		'' AS NUMERO, 
		'' AS DS_CID, 
		0 AS CD_MOT_BLOQ, 
		'LIBERADO' AS DS_MOT_BLOQ, 
		'ESTORNO' AS TP_PAGAMENTO,
		CASE
		WHEN DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN 'ESTORNADO'
		ELSE 'QUITADO'
		END AS SITUACAO, 
		PDV_CUPOM_NAO_FISCAL.HR_CUPOM, 
		'' AS CGC_CPF, 
		PDV_CUPOM_NAO_FISCAL.CD_USU AS CD_OPER, 
		0 AS CD_CNT, 
		'' AS DS_CNT, 
		PDV_CUPOM_NAO_FISCAL.CD_USU, 
		GLB_REG.DS_REG, 
		RC_MDL_VENDA.DS_MDL_VD, 
		RC_MDL_VENDA.CD_MDL_VD, 
		5 AS CONSULTA, 
		0 AS FIL_VENDA, 
		0 AS CAIXA_VENDA, 
		0 AS CUPOM_VENDA,
		'' AS DT_VD
	FROM DBO.PDV_CUPOM_NAO_FISCAL
		INNER JOIN DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_EMP = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_FILIAL = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		AND DBO.PDV_CUPOM_NAO_FISCAL.CD_CTR = DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		INNER JOIN DBO.RC_PGTO_PDV ON DBO.PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = DBO.RC_PGTO_PDV.CD_CTR_PGTO
		LEFT JOIN RC_CLI ON RC_CLI.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP
		AND RC_CLI.CD_CLI = PDV_CUPOM_NAO_FISCAL.CD_CLI
		LEFT OUTER JOIN DBO.RC_CLI_CREDIARIO ON DBO.RC_CLI.CD_EMP = DBO.RC_CLI_CREDIARIO.CD_EMP
		AND DBO.RC_CLI.CD_CLI = DBO.RC_CLI_CREDIARIO.CD_CLI
		LEFT JOIN GLB_REG ON GLB_REG.CD_EMP = RC_CLI.CD_EMP
		AND GLB_REG.CD_REG = RC_CLI.CD_REGI
		LEFT JOIN RC_MDL_VENDA ON RC_CLI_CREDIARIO.CD_EMP = RC_MDL_VENDA.CD_EMP
		AND RC_CLI_CREDIARIO.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD
	WHERE DBO.PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
	UNION ALL

     /*TENTATIVA DE BAIXA,FATURA JA BAIXADA - NCC GERADA(EM ABERTO)*/

     SELECT PDV_CUPOM_NAO_FISCAL.CD_EMP, 
		PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
		PDV_CUPOM_NAO_FISCAL.CD_CTR, 
		PDV_CUPOM_NAO_FISCAL.CD_CX, 
		RC_PGTO_PDV.CD_CTR_PGTO, 
		PDV_CUPOM_NAO_FISCAL.NR_COO, 
		PDV_CUPOM_NAO_FISCAL.DT_CUPOM, 
		PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS VLR_TOT_CUPOM,
		CASE WHEN(ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CHQS, 0) + ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 0) + ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 0)) = 0
		THEN ISNULL(ncc.VLR_NCC, 0)
			ELSE CASE
				WHEN ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_DINH, 0) > 0
				THEN ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_DINH, 0) * (ISNULL(NCC.VLR_NCC, 0) / ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_DINH, 0))
				ELSE 0
				END
		END AS VLR_DINH, 
		ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CHQS, 0) AS VLR_CHQS, 
		ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 0) AS VLR_CARTAO, 
		CAST(PDV_CUPOM_NAO_FISCAL.DT_CUPOM AS DATE) AS DT_PGTO, 
		RC_PGTO_PDV.STS_PGTO, 
		ISNULL(RC_DEB.NR_FATURA, '0') AS NR_FATURA, 
		1 AS PARC, 
		ISNULL(RC_DEB.DT_VENCTO, CONVERT(DATETIME, '1900-01-01 00:00:00', 102)) AS DT_VENCTO_FAT, 
		ISNULL(RC_DEB.VLR_DP, 0) AS VLR_ORIG_FATURA, 
		ISNULL(NCC.VLR_NCC, 0) AS VLR_AMORTIZADO, 
		0 AS VLR_JUR, 
		0 AS VLR_DESC, 
		NCC.VLR_NCC AS VLR_PAGO, 
		ISNULL(RC_DEB.SLD_DP, 0) AS VLR_SALDO, 
		ISNULL(RC_DEB.CD_CLI, 0) AS CD_CLI, 
		ISNULL(RC_CLI.RZ_CLI, '') AS RZ_CLI, 
		ISNULL(RC_CLI.END_CLI, '') AS END_CLI, 
		ISNULL(RC_CLI.BAIRRO, '') AS BAIRRO, 
		ISNULL(RC_CLI.NUMERO, '') AS NUMERO, 
		ISNULL(GLB_CID.DS_CID, '') AS DS_CID, 
		ISNULL(RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI, 0) AS CD_MOT_BLOQ, 
		ISNULL(RC_MOT_BLOQ_CLI.DS_MOT_BLOQ_CLI, 'LIBERADO') AS DS_MOT_BLOQ, 
		'TENTATIVA DE BAIXA,FATURA JA BAIXADA - NCC GERADA(EM ABERTO)' AS TP_PAGAMENTO,
		CASE
		WHEN PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
		THEN 'ESTORNADO'
		ELSE 'QUITADO'
		END AS SITUACAO, 
		PDV_CUPOM_NAO_FISCAL.HR_CUPOM, 
		RC_CLI.CGC_CPF, 
		PDV_CUPOM_NAO_FISCAL.CD_USU AS CD_OPER, 
		0 AS CD_CNT, 
		'' AS DS_CNT, 
		PDV_CUPOM_NAO_FISCAL.CD_USU, 
		GLB_REG.DS_REG, 
		RC_MDL_VENDA.DS_MDL_VD, 
		RC_MDL_VENDA.CD_MDL_VD, 
		6 AS CONSULTA, 
		0 AS FIL_VENDA, 
		0 AS CAIXA_VENDA, 
		0 AS CUPOM_VENDA,
		'' AS DT_VD
			
	FROM RC_DEB_PDV_VD_DEV_NCC
		INNER JOIN RC_DEB ON RC_DEB_PDV_VD_DEV_NCC.CD_EMP = RC_DEB.CD_EMP
		AND RC_DEB_PDV_VD_DEV_NCC.CD_FILIAL = RC_DEB.CD_FILIAL
		AND RC_DEB_PDV_VD_DEV_NCC.CD_RC_DEB = RC_DEB.CD_RC_DEB
		INNER JOIN PDV_VD_DEV_NCC NCC ON NCC.CD_CTR_NCC = RC_DEB_PDV_VD_DEV_NCC.CD_CTR_NCC
		INNER JOIN RC_CLI ON RC_DEB.CD_EMP = RC_CLI.CD_EMP
		AND RC_DEB.CD_CLI = RC_CLI.CD_CLI
		INNER JOIN GLB_CID ON RC_CLI.CD_CID = GLB_CID.CD_CID
		LEFT OUTER JOIN RC_CLI_CREDIARIO ON RC_CLI.CD_EMP = RC_CLI_CREDIARIO.CD_EMP
		AND RC_CLI.CD_CLI = RC_CLI_CREDIARIO.CD_CLI
		INNER JOIN PDV_CUPOM_NAO_FISCAL
		INNER JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON PDV_CUPOM_NAO_FISCAL.CD_EMP = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
		AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
		AND PDV_CUPOM_NAO_FISCAL.CD_CTR = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		INNER JOIN RC_PGTO_PDV ON PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO ON RC_DEB_PDV_VD_DEV_NCC.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO
		LEFT OUTER JOIN RC_MOT_BLOQ_CLI ON RC_CLI_CREDIARIO.CD_MOT_BLOQ_CLI = RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI
		LEFT JOIN GLB_REG ON GLB_REG.CD_EMP = RC_CLI.CD_EMP
		AND GLB_REG.CD_REG = RC_CLI.CD_REGI
		LEFT JOIN RC_MDL_VENDA ON RC_CLI_CREDIARIO.CD_EMP = RC_MDL_VENDA.CD_EMP
		AND RC_CLI_CREDIARIO.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD
	WHERE RC_CLI.CD_EMP = 1
		AND PDV_CUPOM_NAO_FISCAL.TP_CUPOM_NAO_FISCAL = 0

	UNION ALL

     /*TENTATIVA DE BAIXA,ANTECIPCAO JA BAIXADA - NCC GERADA(EM ABERTO)*/

	SELECT PDV_CUPOM_NAO_FISCAL.CD_EMP, 
		PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
		PDV_CUPOM_NAO_FISCAL.CD_CTR, 
		PDV_CUPOM_NAO_FISCAL.CD_CX, 
		RC_PGTO_PDV.CD_CTR_PGTO, 
		PDV_CUPOM_NAO_FISCAL.NR_COO, 
		PDV_CUPOM_NAO_FISCAL.DT_CUPOM, 
		RC_CRED.VLR_PARC_CRED AS VLR_TOT_CUPOM,
		CASE
			WHEN(ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CHQS, 0) + ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 0) + ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 0)) = 0
			THEN ISNULL(ncc.VLR_NCC, 0)
			ELSE CASE
			WHEN ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_DINH, 0) > 0
				THEN ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_DINH, 0) * (ISNULL(NCC.VLR_NCC, 0) / ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_DINH, 0))
				ELSE 0
				END
		END AS VLR_DINH,
		CASE
			WHEN ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CHQS, 0) > 0
			THEN ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CHQS, 0) * (ISNULL(NCC.VLR_NCC, 0) / ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CHQS, 0))
			ELSE 0
		END AS VLR_CHQS,
		CASE
			WHEN ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 0) > 0
			THEN ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 0) * (ISNULL(NCC.VLR_NCC, 0) / ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO, 0))
			ELSE 0
		END AS VLR_CARTAO, 
		CAST(PDV_CUPOM_NAO_FISCAL.DT_CUPOM AS DATE) AS DT_PGTO, 
		RC_PGTO_PDV.STS_PGTO, 
		ISNULL(CAST(RC_CRED.CD_CTR AS VARCHAR), '0') AS NR_FATURA, 
		1 AS PARC, 
		DT_VENCTO_CRED AS DT_VENCTO_FAT, 
		ISNULL(RC_CRED.VLR_PARC_CRED, 0) AS VLR_ORIG_FATURA, 
		ISNULL(NCC.VLR_NCC, 0) AS VLR_AMORTIZADO, 
		0 AS VLR_JUR, 
		0 AS VLR_DESC, 
		NCC.VLR_NCC AS VLR_PAGO, 
		ISNULL(RC_CRED.SLD_PARC_CRED, 0) AS VLR_SALDO, 
		ISNULL(NCC.CD_CLI, 0) AS CD_CLI, 
		ISNULL(RC_CLI.RZ_CLI, '') AS RZ_CLI, 
		ISNULL(RC_CLI.END_CLI, '') AS END_CLI, 
		ISNULL(RC_CLI.BAIRRO, '') AS BAIRRO, 
		ISNULL(RC_CLI.NUMERO, '') AS NUMERO, 
		ISNULL(GLB_CID.DS_CID, '') AS DS_CID, 
		ISNULL(RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI, 0) AS CD_MOT_BLOQ, 
		ISNULL(RC_MOT_BLOQ_CLI.DS_MOT_BLOQ_CLI, 'LIBERADO') AS DS_MOT_BLOQ, 
		'TENTATIVA DE BAIXA,FATURA JA BAIXADA - NCC GERADA(EM ABERTO)' AS TP_PAGAMENTO,
		CASE
			WHEN PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 3
			THEN 'ESTORNADO'
			ELSE 'QUITADO'
		END AS SITUACAO, 
		PDV_CUPOM_NAO_FISCAL.HR_CUPOM, 
		RC_CLI.CGC_CPF, 
		PDV_CUPOM_NAO_FISCAL.CD_USU AS CD_OPER, 
		0 AS CD_CNT, 
		'' AS DS_CNT, 
		PDV_CUPOM_NAO_FISCAL.CD_USU, 
		GLB_REG.DS_REG, 
		RC_MDL_VENDA.DS_MDL_VD, 
		RC_MDL_VENDA.CD_MDL_VD, 
		7 AS CONSULTA, 
		0 AS FIL_VENDA, 
		0 AS CAIXA_VENDA, 
		0 AS CUPOM_VENDA,
		'' AS DT_VD
			
	FROM RC_CREDIARIO_PARC_PDV_VD_DEV_NCC
		INNER JOIN RC_CREDIARIO_PARC RC_CRED ON RC_CREDIARIO_PARC_PDV_VD_DEV_NCC.CD_CTR = RC_CRED.CD_CTR
		INNER JOIN PDV_VD_DEV_NCC NCC ON NCC.CD_CTR_NCC = RC_CREDIARIO_PARC_PDV_VD_DEV_NCC.CD_CTR_NCC
		INNER JOIN RC_CLI ON RC_CRED.CD_EMP = RC_CLI.CD_EMP
						   AND RC_CRED.CD_CLI = RC_CLI.CD_CLI
		INNER JOIN GLB_CID ON RC_CLI.CD_CID = GLB_CID.CD_CID
		LEFT OUTER JOIN RC_CLI_CREDIARIO ON RC_CLI.CD_EMP = RC_CLI_CREDIARIO.CD_EMP
										  AND RC_CLI.CD_CLI = RC_CLI_CREDIARIO.CD_CLI
		INNER JOIN PDV_CUPOM_NAO_FISCAL
		INNER JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON PDV_CUPOM_NAO_FISCAL.CD_EMP = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP
													 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL
													 AND PDV_CUPOM_NAO_FISCAL.CD_CTR = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		INNER JOIN RC_PGTO_PDV ON PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO ON RC_CREDIARIO_PARC_PDV_VD_DEV_NCC.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO
		LEFT OUTER JOIN RC_MOT_BLOQ_CLI ON RC_CLI_CREDIARIO.CD_MOT_BLOQ_CLI = RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI
		LEFT JOIN GLB_REG ON GLB_REG.CD_EMP = RC_CLI.CD_EMP
						   AND GLB_REG.CD_REG = RC_CLI.CD_REGI
		LEFT JOIN RC_MDL_VENDA ON RC_CLI_CREDIARIO.CD_EMP = RC_MDL_VENDA.CD_EMP
								AND RC_CLI_CREDIARIO.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD
	WHERE RC_CLI.CD_EMP = 1
		AND PDV_CUPOM_NAO_FISCAL.TP_CUPOM_NAO_FISCAL = 0;